<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('is_superuser')->after('email')->default(0);
            $table->enum('two_factor_type' , ['off' , 'sms'])->after('email_verified_at');
            $table->string('phone_number')->after('two_factor_type')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('is_superuser');
            $table->dropColumn('two_factor_type');
            $table->dropColumn('phone_number');
        });
    }
};
