<?php

namespace Modules\Acl\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Modules\Acl\Entities\Permission;

class PermissionController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:users-permission-manage');
    }

    public function index()
    {
        $permissions = Permission::query();

        if($keyword = request('search')) {
            $permissions->where('name' , 'LIKE' , "%{$keyword}%")->orWhere('label' , 'LIKE' , "%{$keyword}%" );
        }

        $permissions = $permissions->latest()->paginate(20);
        return view('acl::admin.permissions.viewPermission' , compact('permissions'));
    }


    public function create()
    {
        return view('acl::admin.permissions.addPermission');
    }


    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => ['required', 'string', 'max:255', 'unique:permissions'],
            'label' => ['required', 'string', 'max:255'],
        ]);

        Permission::create($data);

        return redirect(route('permissions.index'));
    }

    public function show(Permission $permission)
    {
        return view('acl::admin.permissions.showUserHavePermission' , compact('permission'));
    }



    public function edit(Permission $permission)
    {
        return view('acl::admin.permissions.editPermission' , compact('permission'));
    }


    public function update(Request $request, Permission $permission)
    {
        $data = $request->validate([
            'name' => ['required', 'string', 'max:255' , Rule::unique('permissions')->ignore($permission->id)],
            'label' => ['required', 'string',  'max:255'],
        ]);

        $permission->update($data);

        //alert()->success('مطلب مورد نظر شما با موفقیت ویرایش شد');
        return redirect(route('permissions.index'));
    }


    public function destroy(Permission $permission)
    {
        $permission->delete();
        //alert()->success('مطلب مورد نظر شما با موفقیت حذف شد');
        return back();
    }
}
