<?php

namespace Modules\Acl\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use \App\Http\Controllers\Controller;
use Modules\Acl\Entities\Permission;
use Modules\Acl\Entities\Role;

class PermissionRoleController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:users-permission-manage')->except(['storeUserRoles']);
        $this->middleware('can:users-role-manage')->only(['storeUserRoles']);
    }

    public function givePermission()
    {
        $permissions = Permission::all();
        $users = User::all();
        return view('acl::admin.permissions.givePermissionToUser', compact(['permissions', 'users']));
    }

    public function giveRole()
    {
        $roles = Role::all();
        $users = User::all();
        return view('acl::admin.roles.giveRoleToUser', compact(['roles', 'users']));
    }

    public function giveRolePer()
    {
        $roles = Role::all();
        $permissions = Permission::all();
        return view('acl::admin.permissions.givePermissionToRole', compact(['roles', 'permissions']));
    }

    public function storeRolePermissions(Request $request)
    {
        $data = $request->validate([
            'role' => ['required'],
        ]);
        $role = Role::findOrFail($request->role);
        $role->permissions()->sync($request->permissions);
        return redirect(route('permissions.index'));

    }


    public function storeUserPermissions(Request $request)
    {
        // see what permissions the user have by his role then add other permission for him
        $data = $request->validate([
            'user' => ['required'],
        ]);

        $user = User::findOrFail($request->user);
        $setper = $request->permissions;

        if(!empty($request->permissions)){
            $getper = array();
            foreach ($user->roles()->get() as $role) {
                $getper = array_merge($getper, $role->permissions->pluck('id')->toArray());
            }
            $setper = Array_diff($request->permissions, $getper);
        }
        $user->permissions()->sync($setper);
        return redirect(route('permissions.index'));

    }

    public function storeUserRoles(Request $request)
    {
        $data = $request->validate([
            'user' => ['required'],
        ]);
        $user = User::findOrFail($request->user);
        $user->roles()->sync($request->roles);
        return redirect(route('users.index'));
    }

    public function showUserPermissionRole(Request $request){
        if ($request->whatreq == 'per'){
            $user = User::findOrFail($request->id);
            $permissions = $user->permissions()->get();
            echo json_encode(['permissions' => $permissions]);
        }elseif ($request->whatreq == 'role'){
            $user = User::findOrFail($request->id);
            $permissions = $user->roles()->get();
            echo json_encode(['permissions' => $permissions]);
        }elseif ($request->whatreq == 'rolePer'){
            $role = Role::findOrFail($request->id);
            $permissions = $role->permissions()->get();
            echo json_encode(['permissions' => $permissions]);
        }

    }


}
