<?php

namespace Modules\Acl\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Modules\Acl\Entities\Role;

class RoleController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:users-permission-manage');
    }
    /**
     * Display a listing of the resource.
     *
     */
    public function index()
    {
        $roles = Role::query();

        if($keyword = request('search')) {
            $roles->where('name' , 'LIKE' , "%{$keyword}%")->orWhere('label' , 'LIKE' , "%{$keyword}%" );
        }

        $roles = $roles->latest()->paginate(20);
        return view('acl::admin.roles.viewRoles' , compact('roles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     *
     */
    public function create()
    {
        return view('acl::admin.roles.addRole');
    }

    /**
     * Store a newly created resource in storage.
     *
     *
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => ['required', 'string', 'max:255', 'unique:roles'],
            'label' => ['required', 'string', 'max:255'],
        ]);


        $role = Role::create($data);


        //alert()->success('مطلب مورد نظر شما با موفقیت ایجاد شد');

        return redirect(route('roles.index'));
    }

    public function show(Role $role)
    {
        return view('acl::admin.roles.showUserHaveRole' , compact('role'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     *
     */
    public function edit(Role $role)
    {
        return view('acl::admin.roles.editRole' , compact('role'));
    }

    /**
     * Update the specified resource in storage.
     *
     *
     */
    public function update(Request $request, Role $role)
    {
        $data = $request->validate([
            'name' => ['required', 'string', 'max:255' , Rule::unique('roles')->ignore($role->id)],
            'label' => ['required', 'string',  'max:255'],
        ]);

        $role->update($data);

        //alert()->success('مطلب مورد نظر شما با موفقیت ویرایش شد');
        return redirect(route('roles.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     *
     */
    public function destroy(Role $role)
    {
        $role->delete();
        //alert()->success('مطلب مورد نظر شما با موفقیت حذف شد');
        return back();
    }

}
