@component('admin.adminMaster.content' , ['title' => 'مدیریت دسترسی نقش ها'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('roles.index') }}">لیست نقش ها</a></li>
        <li class="breadcrumb-item active">مدیریت دسترسی نقش ها</li>
    @endslot

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">مدیریت دسترسی نقش ها</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form class="form-horizontal" action="{{ route('roleper.store') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <label>انتخاب نقش</label>
                                <select id="select1" name="role" class="form-control" onchange="setSelection('rolePer')">
                                    <option value="" disabled selected>نقش مورد نظر را انتخاب کنید</option>
                                    <?php foreach ($roles as $role){
                                        echo "<option value=".$role->id.">".$role->label."</option>";
                                    }?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="inputEmail3" class="col-sm-2 control-label">انتخاب دسترسی ها</label>
                                <select class="form-control" name="permissions[]" id="select2" multiple>
                                    @foreach($permissions as $permission)
                                        <option value="{{ $permission->id }}">{{ $permission->name }} - {{ $permission->label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-info">ثبت دسترسی</button>
                            <a href="{{ route("permissions.index") }}" class="btn btn-default float-left">لغو</a>
                        </div>
                        <!-- /.card-footer -->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
    @slot('script')
        <script src="/dist/js/select.js"></script>
    @endslot

@endcomponent
