@component('admin.adminMaster.content' , ['title' => 'کاربران دارای دسترسی'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('permissions.index') }}">دسترسی ها</a></li>
        <li class="breadcrumb-item active">کاربران دارای دسترسی</li>
    @endslot

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">کاربران دارای دسترسی</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>نام دسترسی</th>
                                <th>توضیح دسترسی</th>
                            </tr>
                            <tr>
                                <td>{{ $permission->name }}</td>
                                <td>{{ $permission->label }}</td>
                            </tr>
                        </table>
                        <table class="table table-hover">
                        <tr>
                            <th>آیدی کاربر</th>
                            <th>نام</th>
                            <th>ایمیل</th>
                            <th>نقش کاربر</th>
                        </tr>
                            @foreach($permission->users()->get() as $user)
                                <tr>
                                <td>{{$user -> id}}</td>
                                <td>{{$user -> name}}</td>
                                <td>{{$user -> email}}</td>
                                <td>
                                    @if($user->roles()->get()->first() == null)
                                        <?= "تعریف نشده" ?>
                                        @else
                                            @foreach($user->roles()->get() as $role)
                                                <?= "*" ?>
                                                {{$role->label}}
                                            @endforeach
                                    @endif
                                </td>
                                </tr>
                            @endforeach
                            @foreach($permission->roles()->get() as $role)
                                @foreach($role->users()->get() as $user)
                                    <tr>
                                        <td>{{$user -> id}}</td>
                                        <td>{{$user -> name}}</td>
                                        <td>{{$user -> email}}</td>
                                        <td>
                                            @if($user->roles()->get()->first() == null) <?= "تعریف نشده" ?> @endif
                                            @foreach($user->roles()->get() as $role)
                                                <?= "*" ?>
                                                {{$role->label}}
                                            @endforeach
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    </section>

@endcomponent
