@component('admin.adminMaster.content' , ['title' => 'دسترسی ها'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">دسترسی ها</li>
    @endslot

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">دسترسی ها</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                                @can('super-user')
                                    <div class="btn-group-sm mr-1">
                                        <a href="{{route('permissions.create')}}" class="btn btn-info">ایجاد دسترسی جدید
                                            <li class="fa fa-pencil"></li>
                                        </a>
                                    </div>
                                @endcan
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>نام دسترسی</th>
                                <th>توضیح دسترسی</th>
                                <th>اقدامات</th>
                            </tr>
                            @foreach($permissions as $permission)
                                <tr>
                                    <td>{{ $permission->name }}</td>
                                    <td>{{ $permission->label }}</td>
                                    <td class="d-flex">
                                        <a href="{{ route('permissions.show' ,$permission->id) }}"
                                           class="btn btn-sm btn-warning ml-1">مشاهده کاربران</a>
                                        @can('super-user')
                                        <form action="{{ route('permissions.destroy' ,  $permission->id) }}"
                                              method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger ml-1">حذف</button>
                                        </form>
                                        <a href="{{ route('permissions.edit' ,$permission->id) }}"
                                           class="btn btn-sm btn-primary">ویرایش</a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        {{$permissions->render()}}
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    </section>

@endcomponent
