<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\User;
use Illuminate\Http\Request;

class ManageCustomersController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:manage-customers');
    }

    public function index()
    {
        $customers= Customer::query()->paginate(10);
        return view('admin.customers.viewCustomers',compact('customers'));
    }

    public function edit(Customer $customer){
        return view('admin.customers.editCustomer' , compact('customer'));
    }

    public function update(Request $request, Customer $customer)
    {
        $data = $request->validate([
            'email' => ['required', 'string', 'email', 'max:255'],
        ]);

        $customer->update([
            'email' =>  $data['email'],
        ]);

        return redirect(route('customers.index'));
    }

    public function destroy(Customer $customer)
    {
        $customer->delete();
        return redirect(route('customers.index'));
    }

    public function show(Customer $customer){
        return view('admin.customers.viewCustomersDetails' , compact('customer'));
    }
}
