<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Carbon\Carbon;
use Hekmatinasser\Verta\Verta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ManageFinancialController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:manage-financial');
    }

    public function getMonthlyReports(Request $request){
        $data = $request->validate([
            'year' => ['integer']
        ]);

        if (!isset($data['year'])){
            $data['year'] = verta(Carbon::now())->year;
        }

        $selectYear = $data['year'];
        $reports = [];

        $months[1]= [
            'name' => 'فروردین',
            'start' => '01-01',
            'end' => '01-31'
        ];
        $months[2]= [
            'name' => 'اردیبهشت',
            'start' => '02-01',
            'end' => '02-31'
        ];
        $months[3]= [
            'name' => 'خرداد',
            'start' => '03-01',
            'end' => '03-31'
        ];
        $months[4]= [
            'name' => 'تیر',
            'start' => '04-01',
            'end' => '04-31'
        ];
        $months[5]= [
            'name' => 'مرداد',
            'start' => '05-01',
            'end' => '05-31'
        ];
        $months[6]= [
            'name' => 'شهریور',
            'start' => '06-01',
            'end' => '06-31'
        ];
        $months[7]= [
            'name' => 'مهر',
            'start' => '07-01',
            'end' => '07-30'
        ];
        $months[8]= [
            'name' => 'آبان',
            'start' => '08-01',
            'end' => '08-30'
        ];
        $months[9]= [
            'name' => 'آذر',
            'start' => '09-01',
            'end' => '09-30'
        ];
        $months[10]= [
            'name' => 'دی',
            'start' => '10-01',
            'end' => '10-30'
        ];
        $months[11]= [
            'name' => 'بهمن',
            'start' => '11-01',
            'end' => '11-30'
        ];
        $months[12]= [
            'name' => 'اسفند',
            'start' => '12-01',
            'end' => '12-29'
        ];

        $i = 1; //an Counter for month
        foreach ($months as $month){
            $item = [];
            $item['id'] = $i ++;
            $item['month'] = $month['name'];
            $month['start'] = $selectYear.'-'.$month['start'];
            $month['end'] = $selectYear.'-'.$month['end'];
            $item['start'] = Verta::parse($month['start'])->toCarbon()->format('Y-m-d');
            $item['end'] = Verta::parse($month['end'])->toCarbon()->format('Y-m-d');
            $item['total'] = Order::select('price')->whereBetween('created_at', [$item['start'], $item['end']])->get()->sum('price');
            array_push($reports,$item);
        }

        $years = \App\Models\Order::select(DB::raw("DATE_FORMAT(created_at, '%Y') as new_date"),'created_at')
            ->groupBy('new_date')->orderBy('new_date','desc')->get();

        return view('admin.accounting.reports',compact('reports','years','selectYear'));
    }

    public function getReportDetails(Request $request){
        $data = $request->validate([
            'start' => ['required','date'],
            'end' => ['required','date']
        ]);

        $orders = Order::whereBetween('created_at', [$data['start'], $data['end']])->paginate(10);

        $year = verta($data['start'])->year;
        $month = verta($data['start'])->formatWord('F');

        return view('admin.accounting.viewReportDetails' , compact('orders','year','month'));
    }
}
