<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\Order;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ManageOrdersController extends Controller
{
    public function __construct()
    {
        $this->middleware('can:manage-orders');
    }

    public function index()
    {
        $orders= Order::query()->paginate(10);
        return view('admin.orders.viewOrders',compact('orders'));
    }

    public function create(){
        return view('admin.orders.addOrder');
    }

    public function edit(Order $order){
        return view('admin.orders.editOrder' , compact('order'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'email' => ['required', 'string', 'email', 'max:255'],
            'username' => ['string', 'max:255'],
            'server' => ['required', 'integer'],
            'Price' => ['required', 'integer'],
            'operator' => ['required', 'string', 'max:255'],
            'start_date' => ['required', 'date'],
            'end_date' => ['required', 'date'],
            'pay_status' => [],
        ]);

        if (isset($data['pay_status'])){
            $data['pay_status'] = 1;
        }else{
            $data['pay_status'] = 0;
        }
        if(!isset($data['username'])){
            $data['username'] = null;
        }

        $customer = Customer::where([['email','=',$data['email']]])->get()->first();
        if ($customer == null){
            $customer = Customer::create([
                'email' => $data['email'],
                'username' => $data['username'],
                'person_id' => auth()->user()->id,
            ]);
        }else{
            if ($data['username'] != null){
                $checkUsername = Customer::where([['username','=',$data['username']]])->get()->first();
                if ($customer->username == null && $checkUsername == null){
                    $customer->update([
                        'username' =>  $data['username'],
                    ]);
                }else{
                    $error = "خطا: نام کاربری وارد شده تکراری است یا کاربر قبلا دارای نام کاربری بوده است";
                    return view('admin.orders.addOrder')->withErrors($error);
                }
            }
        }

        Order::create([
            'customer_id' => $customer->id,
            'server_id' =>  $data['server'],
            'price' =>  $data['Price'],
            'operator' =>  $data['operator'],
            'person_id' => auth()->user()->id,
            'pay_status' =>  $data['pay_status'],
            'created_at' =>  $data['start_date'],
            'expired_at' =>  $data['end_date'],
        ]);

        return redirect(route('orders.index'));
    }


    public function update(Request $request, Order $order)
    {
        $data = $request->validate([
            'email' => ['required', 'string', 'email', 'max:255'],
            'server' => ['required', 'integer'],
            'Price' => ['required', 'integer'],
            'operator' => ['required', 'string', 'max:255'],
            'start_date' => ['required', 'date'],
            'end_date' => ['required', 'date'],
            'pay_status' => [],
        ]);

        if (isset($data['pay_status'])){
            $data['pay_status'] = 1;
        }else{
            $data['pay_status'] = 0;
        }

        $order->update([
            'server_id' =>  $data['server'],
            'price' =>  $data['Price'],
            'operator' =>  $data['operator'],
            'person_id' => auth()->user()->id,
            'pay_status' =>  $data['pay_status'],
            'created_at' =>  $data['start_date'],
            'expired_at' =>  $data['end_date'],
        ]);

        return redirect(route('orders.index'));
    }

    public function destroy(Order $order)
    {
        $order->delete();
        return redirect(route('orders.index'));
    }

    public function searchOrders(Request $request){
        $data = $request->validate([
            'status'=>['int','max:3'],
        ]);

        $orders = $this->search($data)->paginate(10);
        return view('admin.orders.searchOrders',compact('orders'));
    }

    public function expertSearchOrders(Request $request){
        $data = $request->validate([
            'email' => [],
            'username' => [],
            'server' => [],
            'operator' => [],
            'pay_status' => [],
            'status'=>[],
        ]);

        $orders = $this->search($data)->paginate(10);
        return view('admin.orders.searchOrders',compact('orders'));
    }

    public  function search($data){
        $query = Order::select('*')->join('customers','customers.id' , '=' , 'orders.customer_id');
        if (isset($data['email']) && $data['email']){
            $query->where([['email', 'like', '%' .$data [ 'email' ]. '%']]);
        }
        if (isset($data['username']) && $data['username']){
            $query->where([['username', 'like', '%' .$data [ 'username' ]. '%']]);
        }
        if (isset($data['server']) && $data['server'] != 'انتخاب نشده'){
            $query->where([['server', '=',$data [ 'server' ]]]);
        }
        if (isset($data['operator']) && $data['operator'] != 'انتخاب نشده'){
            $query->where([['operator', 'like', '%' .$data [ 'operator' ]. '%']]);
        }
        if (isset($data['pay_status']) && $data['pay_status'] != 'انتخاب نشده'){
            $query->where([['pay_status', '=', $data ['pay_status']]]);
        }
        if (isset($data['status']) && $data['status'] != 'انتخاب نشده'){
            if ($data['status'] == 1){
                $query->where([['expired_at', '>', Carbon::now()]]);
            }elseif ($data['status'] == 0){
                $query->where([['expired_at', '<=', Carbon::now()]]);
            }
        }

        return $query;
    }
}
