<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $fillable = [
        'id', 'customer_id','server_id','operator','person_id','price','pay_status','expired_at','created_at','updated_at',
    ];

    public function whocreate($id){
        return User::where([['id','=',$id]])->get()->first();
    }

    public function whoOrder($id){
        return Customer::where([['id','=',$id]])->get()->first();
    }

    public function whatServer($id){
        return Server::where([['id','=',$id]])->get()->first();
    }
}
