<?php
    use Carbon\Carbon;
?>
@extends('admin.adminMaster.admaster')

@section('title' , 'داشبورد')

@section('content')
    <div class="row">
        <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo $orders->count();?></h3>

                    <p>همه سفارشات</p>
                </div>
                <div class="icon">
                    <i class="ion ion-bag"></i>
                </div>
                <a href="{{route('orders.index')}}" class="small-box-footer">اطلاعات بیشتر <i class="fa fa-arrow-circle-left"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo $customers->count();?></h3>

                    <p>مشتریان</p>
                </div>
                <div class="icon">
                    <i class="fa fa-user-circle"></i>
                </div>
                <a href="{{route('customers.index')}}" class="small-box-footer">اطلاعات بیشتر <i class="fa fa-arrow-circle-left"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo \App\Models\Order::where([['expired_at','>',Carbon::now()]])->count(); ?></h3>

                    <p>کانفینگ های فعال</p>
                </div>
                <div class="icon">
                    <i class="fa fa-check-circle"></i>
                </div>
                <a href="{{'/admin/searchOrders?status=1'}}" class="small-box-footer">اطلاعات بیشتر <i class="fa fa-arrow-circle-left"></i></a>
            </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3><?php echo \App\Models\Order::where([['expired_at','<=',Carbon::now()]])->count(); ?></h3>

                    <p>کانفینگ های منقضی شده</p>
                </div>
                <div class="icon">
                    <i class="fa fa-close"></i>
                </div>
                <a href="{{'/admin/searchOrders?status=0'}}" class="small-box-footer">اطلاعات بیشتر <i class="fa fa-arrow-circle-left"></i></a>
            </div>
        </div>
        <!-- ./col -->
    </div>
    <!-- /.row -->
    <!-- Main row -->
    <div class="row">
        <!-- Left col -->
        <section class="col-lg-8 connectedSortable" style="margin: auto">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
                <div class="card-header d-flex p-0">
                    <h3 class="card-title p-3">
                        <i class="fa fa-pie-chart mr-1"></i>
                        نمودار فروش
                    </h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="chartContainer" style="height: 300px; width: 100%;"/>
                </div><!-- /.card-body -->
            </div>
            <!-- /.card -->
        </section>
        <!-- /.Left col -->
        <!-- right col (We are only adding the ID to make the widgets sortable)-->
        <!-- right col -->
    </div>

@endsection

@section('script')
    <script type="text/javascript" src="/plugins/jquery/jquery-1.11.1.min.js"></script>
    <script type="text/javascript" src="/plugins/jquery/jquery.canvasjs.min.js"></script>
    <script type="text/javascript">
        $(function() {
            $(".chartContainer").CanvasJSChart({
                title: {
                    text: <?php echo '"'.'فروش ماهیانه در سال '.$selectYear.'"' ?>
                },
                axisY: {
                    title: "مبلغ به تومان",
                    includeZero: false
                },
                axisX: {
                    interval: 1
                },
                data: [
                    {
                        type: "line", //try changing to column, area
                        toolTipContent: "{label}: {y} تومان",
                        dataPoints: [
                            <?php
                                foreach ($reports as $item){
                                    echo "{ label: ".'"'.$item['month'].'"'.",  y: ".$item['total'].' },'."\n";
                                }
                                ?>
                        ]
                    }
                ]
            });
        });
    </script>
@endsection
