@component('admin.adminMaster.content' , ['title' => 'مقاله جدید'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="/admin/viewArticles">مشاهده مقالات</a></li>
        <li class="breadcrumb-item active">مقاله جدید</li>
    @endslot

    <div class="card card-info card-outline">
        <div class="card-header">
            <h3 class="card-title">افزودن مقاله جدید
            </h3>
        </div>
        @if($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{$error}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <!-- /.card-header -->
        <div class="card-body">
            <form action="/admin/newArticle" method="post" enctype="multipart/form-data">
                @csrf
                <table class="table table-bordered">
                    <tr>
                        <td style="width: 50%">
                            <div class="form-group">
                                <label for="title">عنوان مقاله</label>
                                <input type="text" name="title" class="form-control" id="title" placeholder="عنوان مقاله" required="required">
                            </div>
                        </td>
                        <td style="width: 50%">
                            <div class="form-group">
                                <label>دسته بندی</label>
                                <select name="category" class="form-control">
                                    <?php foreach ($categ as $item){
                                        echo "<option>".$item->name."</option>";
                                    }?>
                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 50%">
                            <table class="table table-bordered">
                                <tr>
                                    <td>
                                        <div class="form-group">
                                            <label for="slug">آدرس یکتا</label>
                                            <input type="text" name="slug" class="form-control" id="slug" placeholder="آدرس یکتا" required="required">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="form-group">
                                            <label for="hashtag">برچسب ها&nbsp<small>(لطفا بین برچسب ها از علامت - استفاده کنید)</small></label>
                                            <input type="text" name="hashtag" class="form-control" id="hashtag" placeholder="برچسب ها">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div id="wrapper">
                                            <label for="fileUpload">تصویر اصلی</label>
                                            <input id="fileUpload" name="image" type="file" multiple required="required" />
                                            <br />
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td style="display: flex;justify-content: center;text-align: center;">
                            <br/>
                            <label for="image-holder">پیش نمایش</label>
                            <div id="image-holder"></div>
                        </td>
                    </tr>
                </table>
                <textarea id="editor1" name="editor1" rows="10" cols="80" required="required"></textarea>
                <input type="hidden" name="writer" value="<?= auth()->user()->id ?>">
                <button class="btn btn-block btn-primary btn-lg"  type="submit">تایید</button>
            </form>
        </div>
    </div>

    @slot('script')

    <!-- CK Editor -->
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script>
        $(function () {
                CKEDITOR.replace('editor1')
        })
    </script>
    /////
    <script>
        $("#fileUpload").on('change', function () {

            //Get count of selected files
            var countFiles = $(this)[0].files.length;

            var imgPath = $(this)[0].value;
            var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
            var image_holder = $("#image-holder");
            image_holder.empty();

            if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
                if (typeof (FileReader) != "undefined") {

                    //loop for each file selected for uploaded.
                    for (var i = 0; i < countFiles; i++) {

                        var reader = new FileReader();
                        reader.onload = function (e) {
                            $("<img  />", {
                                "src": e.target.result,
                                "class": "thumb-image"
                            }).appendTo(image_holder);
                        }

                        image_holder.show();
                        reader.readAsDataURL($(this)[0].files[i]);
                    }

                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Pls select only images");
            }
        });
    </script>

    @endslot
@endcomponent
