@component('admin.adminMaster.content' , ['title' => 'ویرایش نظرات'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="/admin/viewComments">نظرات</a></li>
        <li class="breadcrumb-item active">ویرایش نظرات</li>
    @endslot
    <div class="card card-info card-outline">
        <div class="card-header">
            <h3 class="card-title">ویرایش نظرات
            </h3>
        </div>
        @if($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{$error}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <!-- /.card-header -->
        <div class="card-body">
            <form action="/admin/editComment/{{$comments->id}}" method="post" enctype="multipart/form-data">
                @csrf
                <table class="table table-bordered">
                    <tr>
                        <td>
                            <div class="form-group">
                                <label for="writer">نام نویسنده</label>
                                <input type="text" name="writer" class="form-control" id="writer"
                                       placeholder="نام نویسنده" value="{{$comments->writer}}" required="required">
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <label for="email">ایمیل</label>
                                <input type="email" name="email" class="form-control" id="email"
                                       placeholder="ایمیل نویسنده" value="{{$comments->email}}" required="required">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="form-group">
                                <label>وضعیت</label>
                                <select name="status" class="form-control">
                                    <option <?php if ($comments->status == 0) {
                                        echo "selected";
                                    }?> value="0">رد
                                    </option>
                                    <option <?php if ($comments->status == 1) {
                                        echo "selected";
                                    }?> value="1">تایید
                                    </option>
                                    <option <?php if ($comments->status == 2) {
                                        echo "selected";
                                    }?> value="2">در انتظار بررسی
                                    </option>
                                </select>
                            </div>
                        </td>
                    </tr>
                </table>
                <textarea id="editor1" name="editor1" rows="10" cols="80"
                          required="required"><?= $comments->body ?></textarea>
                <button style="width: fit-content;" class="btn btn-block btn-danger btn-lg" type="submit">ویرایش
                </button>
            </form>
        </div>
    </div>

@slot('script')

    <!-- CK Editor -->
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script>
        $(function () {
            CKEDITOR.replace('editor1')
        })
    </script>

@endslot
@endcomponent
