@component('admin.adminMaster.content' , ['title' => 'نظرات'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">نظرات</li>
    @endslot

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">مدیریت نظرات</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 150px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>نام نویسنده</th>
                                <th>متن نظر</th>
                                <th>وضعیت</th>
                                <th>تاریخ ثبت</th>
                                <th>نام مقاله</th>
                                <th>عملیات</th>
                            </tr>
                            <?php
                            foreach ($comments as $comment){?>
                            <tr>
                                <td>{{$comment->writer}}</td>
                                <td>{{mb_substr($comment->body,0,40)." ..."}}</td>
                                <td>
                                    @if($comment->status == 0)
                                        <span class="badge badge-danger">رد شده</span>
                                    @elseif($comment->status == 1)
                                        <span class="badge badge-success">تایید شده</span>
                                    @else
                                        <span class="badge badge-warning">در انتظار بررسی</span>
                                    @endif
                                </td>
                                <td>{{$comment->created_at}}</td>
                                <td>{{$comment->title}}</td>

                                <td colspan="5"><a href="/admin/showComment/{{$comment->id}}" class="btn bg-warning btn-sm">مشاهده</a>
                                    @can('manage-comments')
                                        <a href="/admin/acceptComment/{{$comment->id}}"
                                           class="btn btn-success btn-sm <?php if ($comment->status == 1) {echo "disabled";} ?>">تایید</a>
                                        <a href="/admin/rejecComment/{{$comment->id}}"
                                           class="btn bg-danger btn-sm <?php if ($comment->status == 0) {echo "disabled";} ?>">رد</a>
                                        <a href="/admin/editComment/{{$comment->id}}" class="btn btn-primary btn-sm">ویرایش</a>
                                        <a href="/admin/deleteComment/{{$comment->id}}" class="btn bg-danger-gradient btn-sm">حذف</a>
                                    @endcan
                                </td>
                            </tr>
                            <?php } ?>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        {{$comments->render()}}
                    </div>
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>

@endcomponent
