@component('admin.adminMaster.content' , ['title' => 'سفارش جدید'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('orders.index') }}">لیست کافینگ ها</a></li>
        <li class="breadcrumb-item active">سفارش جدید</li>
    @endslot
        <div class="row">
            <div class="col-12">
                @include('admin.adminMaster.errors')
                <div class="card card-primary"  style="width: 50%;margin: auto" >
                    <div class="card-header">
                        <h3 class="card-title">ایجاد سفارش جدید</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form class="form-horizontal" action="{{route('orders.store')}}" method="POST">
                        @csrf

                        <div class="card-body">
                            <div class="form-group">
                                <label for="email" class="col-sm-2 control-label">ایمیل مشتری</label>
                                <input type="email" name="email" class="form-control" id="inputEmail3" placeholder="ایمیل را وارد کنید">
                            </div>
                            <div class="form-group">
                                <label for="username" class="col-sm-5 control-label">نام کاربری (username)</label>
                                <input type="text" name="username" class="form-control" id="username" placeholder="نام کاربری را وارد کنید">
                            </div>
                            <div class="form-group">
                                <label>سرور</label>
                                <select name="server" class="form-control">
                                   <?php
                                    $servers = \App\Models\Server::select('id','name')->get();
                                    foreach ($servers as $item){
                                        echo '<option value="'.$item->id.'">'.$item->name.'</option>';
                                    }?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>اپراتور</label>
                                <select name="operator" class="form-control">
                                    <option value="1">ایرانسل</option>
                                    <option>همراه اول</option>
                                    <option>رایتل</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>تاریخ شروع</label>
                                <div class="input-group">
                                    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-calendar"></i></span></div>
                                    <input type="text" id="startdatepicker" name="start_date" class="form-control ltr" >
                                </div>
                            </div>
                            <div class="form-group">
                                <label>تاریخ پایان</label>
                                <div class="input-group">
                                    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-calendar"></i></span></div>
                                    <input type="text" id="enddatepicker" name="end_date" class="form-control ltr" >
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="Price" class="col-sm-2 control-label">قیمت</label>
                                <input type="number" inputmode="numeric" data-type="currency" name="Price" class="form-control" id="Price" placeholder="قیمت را وارد کنید" >
                                <br>
                                <input style="margin-right: 20px" type="checkbox" name="pay_status" class="form-check-input" id="verify">
                                <label style="margin-right: 40px" class="form-check-label" for="pay_status">پرداخت شده</label>
                            </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-info">ثبت سفارش</button>
                            <a href="{{route('orders.index')}}" class="btn btn-default float-left">لغو</a>
                        </div>
                        <!-- /.card-footer -->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    @slot('script')
        <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
        <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
        <script>
            $( function() {
                $( "#startdatepicker" ).datepicker({
                    changeMonth: true,
                    changeYear: true
                });
                $( "#enddatepicker" ).datepicker({
                    changeMonth: true,
                    changeYear: true
                });
                $(document).ready(function() {
                    $( "#startdatepicker" ).datepicker( "option", "dateFormat", "yy-mm-dd" );
                    $( "#enddatepicker" ).datepicker( "option", "dateFormat", "yy-mm-dd" );
                });
            } );
        </script>
    @endslot
@endcomponent
