@component('admin.adminMaster.content' , ['title' => 'ویرایش سرور'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('servers.index') }}">لیست سرورها</a></li>
        <li class="breadcrumb-item active">ویرایش سرور</li>
    @endslot
        <div class="row">
            <div class="col-12">
                @include('admin.adminMaster.errors')
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">فرم ویرایش سرور</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form class="form-horizontal" action="{{ route('servers.update', ['server' => $server->id]) }}" method="POST">
                        @csrf
                        @method('PATCH')

                        <div class="card-body">
                            <div class="form-group">
                                <label for="name" class="col-sm-2 control-label">نام سرور</label>
                                <input type="text" name="name" class="form-control" id="inputEmail3" placeholder="نام سرور را وارد کنید" value="{{ $server->name }}">
                            </div>
                            <div class="form-group">
                                <label for="server" class="col-sm-2 control-label">ip سرور</label>
                                <input type="text" name="ip" class="form-control" id="inputEmail3" placeholder="ip سرور را وارد کنید" value="{{ $server->ip }}">
                            </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-info">ویرایش سرور</button>
                            <a href="{{route('servers.index')}}" class="btn btn-default float-left">لغو</a>
                        </div>
                        <!-- /.card-footer -->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
@endcomponent
