@component('admin.adminMaster.content' , ['title' => 'کاربران'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">لیست کاربران</li>
    @endslot

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست کاربران</h3>
                    <div class="card-tools d-flex">
                        <div class="input-group input-group-sm" style="width: 300px;">
                            <input type="text" name="table_search" class="form-control float-right" placeholder="جستجو">

                            <div class="input-group-append">
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                            @can('create-user')
                                <div class="btn-group-sm mr-1">
                                    <a href="{{route('users.create')}}" class="btn btn-info">افزودن کاربر جدید
                                        <li class="fa fa-pencil"></li>
                                    </a>
                                </div>
                            @endcan
                        </div>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>نام</th>
                            <th>ایمیل</th>
                            <th>وضعیت ایمیل</th>
                            <th>نقش کاربر</th>
                            <th>تاریخ ثبت نام</th>
                        </tr>
                        <?php
                        foreach ($users as $item){
                        ?>
                        <tr>
                            <td>{{$item->id}}</td>
                            <td>{{$item->name}}</td>
                            <td>{{$item->email}}</td>
                            <td>
                                @if($item->email_verified_at !== null)
                                    <span class="badge badge-success">تایید شده</span>
                                @else
                                    <span class="badge badge-danger">تایید نشده</span>
                                @endif
                            </td>
                            <td>
                                @if($item->roles()->get()->first() == null)
                                    <?= "تعریف نشده" ?>
                                @endif
                                @foreach($item->roles()->get() as $role)
                                    <?= "*" ?>
                                    {{$role->label}}
                                @endforeach
                            </td>
                            <td>{{$item->created_at}}</td>
                            <td class="d-flex">
                                @can('edit-user')
                                    <a href="{{ route('users.edit' , ['user' => $item->id]) }}"
                                       class="btn btn-info btn-sm">ویرایش</a>
                                @endcan
                                @can('delete-user')
                                    <form action="{{ route('users.destroy' , ['user' => $item->id]) }}"
                                          method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger mr-1">حذف</button>
                                    </form>
                                @endcan
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    {{$users->render()}}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>

@endcomponent
