<?php

use App\Http\Controllers\ArticleViewController;
use App\Models\Article;
use App\Models\Category;
use App\Models\Comment;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\HomeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', "HomeController@home");

Route::get('/about-us', 'HomeController@about');

Route::get('/contact', 'HomeController@contact');

Route::get('/our-work','HomeController@ourwork');

Route::get('/blog', 'HomeController@blog');

Route::get('/services', 'HomeController@services');

/*//for auto update
Route::get('/deploy', function (){
    ob_start();
    require(path("public")."deploy.php");
    return ob_get_clean();
});*/


Route::get('/login', function () {
    return view('login');
});

///////////////////////// Single-Pages Route map ///////////////////////////////////
Route::get('/blog/{slug}', 'SinglePagesController@show');

///////////////////////// ٔNew Comment Route map ///////////////////////////////////
Route::post('/newComment/{article_id}/{parent_id}', 'Admin\CommentController@addComment');



Auth::routes(['register' => false,'verify' => true]);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
