<?php $__env->startComponent('admin.adminMaster.content' , ['title' => 'نقش ها']); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">لیست نقش ها</li>
    <?php $__env->endSlot(); ?>

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">نقش ها</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                                <div class="btn-group-sm mr-1">
                                    <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-info">ایجاد نقش جدید
                                        <li class="fa fa-pencil"></li>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>نام نقش</th>
                                <th>توضیح نقش</th>
                                <th>اقدامات</th>
                            </tr>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($role->name); ?></td>
                                    <td><?php echo e($role->label); ?></td>
                                    <td class="d-flex">
                                        <a href="<?php echo e(route('roles.show' ,$role->id)); ?>"
                                           class="btn btn-sm btn-warning ml-1">مشاهده کاربران</a>
                                        <form action="<?php echo e(route('roles.destroy' ,  $role->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger ml-1">حذف</button>
                                        </form>
                                        <a href="<?php echo e(route('roles.edit' ,$role->id)); ?>" class="btn btn-sm btn-primary">ویرایش</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        <?php echo e($roles->render()); ?>

                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    </section>

<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/birvpn/public_html/Modules/Acl/Resources/views/admin/roles/viewRoles.blade.php ENDPATH**/ ?>