@component('admin.adminMaster.content' , ['title' => 'دادن دسترسی'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('users.index') }}">لیست کاربران</a></li>
        <li class="breadcrumb-item active">دادن دسترسی به کاربر</li>
    @endslot

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">دادن دسترسی به کاربر</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form class="form-horizontal" action="{{ route('userper.store') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <label>انتخاب کاربر</label>
                                <select id="select1" name="user" class="form-control" onchange="setSelection('per')">
                                    <option value="" disabled selected>کاربر مورد نظر را انتخاب کنید</option>
                                    <?php foreach ($users as $user){
                                        echo "<option value=".$user->id.">".$user->name."</option>";
                                    }?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="inputEmail3" class="col-sm-2 control-label">انتخاب دسترسی ها</label>
                                <select class="form-control" name="permissions[]" id="select2" multiple>
                                    @foreach($permissions as $permission)
                                        <option value="{{ $permission->id }}">{{ $permission->name }} - {{ $permission->label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-info">ثبت دسترسی</button>
                            <a href="{{ route("permissions.index") }}" class="btn btn-default float-left">لغو</a>
                        </div>
                        <!-- /.card-footer -->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>

    @slot('script')
        <script src="/dist/js/select.js"></script>
    @endslot

@endcomponent
