@component('admin.adminMaster.content' , ['title' => 'دادن نقش به کاربر'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('users.index') }}">لیست کاربران</a></li>
        <li class="breadcrumb-item active">دادن نقش به کاربر</li>
    @endslot
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">فرم تعیین نقش کاربر</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form class="form-horizontal" action="{{ route('userrole.store') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="form-group">
                                <label>انتخاب کاربر</label>
                                <select id="select1" name="user" class="form-control" onchange="setSelection('role')">
                                    <option value="" disabled selected>کاربر مورد نظر را انتخاب کنید</option>
                                    <?php foreach ($users as $user){
                                        echo "<option value=".$user->id.">".$user->name."</option>";
                                    }?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="inputEmail3" class="col-sm-2 control-label">انتخاب نقش</label>
                                <select class="form-control" name="roles[]" id="select2" multiple>
                                    @foreach($roles as $role)
                                        <option value="{{ $role->id }}">{{ $role->name }} - {{ $role->label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-info">ثبت نقش</button>
                            <a href="{{ route('roles.index') }}" class="btn btn-default float-left">لغو</a>
                        </div>
                        <!-- /.card-footer -->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>

    @slot('script')
            <script src="/dist/js/select.js"></script>
    @endslot

@endcomponent
