@component('admin.adminMaster.content' , ['title' => 'کاربران داری نقش'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('roles.index') }}">لیست نقش ها</a></li>
        <li class="breadcrumb-item active">کاربران داری نقش</li>
    @endslot

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">کاربران داری نقش</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>نام نقش</th>
                                <th>توضیح نقش</th>
                            </tr>
                            <tr>
                                <td>{{ $role->name }}</td>
                                <td>{{ $role->label }}</td>
                            </tr>
                        </table>
                        <table class="table table-hover">
                        <tr>
                            <th>ردیف</th>
                            <th>نام</th>
                            <th>ایمیل</th>
                        </tr>
                            @foreach($role->users()->get() as $key => $user)
                                <tr>
                                <td>{{$key+1}}</td>
                                <td>{{$user -> name}}</td>
                                <td>{{$user -> email}}</td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    </section>

@endcomponent
