<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Carbon\Carbon;
use Hekmatinasser\Verta\Verta;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index(){

        $selectYear = verta(Carbon::now())->year;;
        $reports = [];

        $months[1]= [
            'name' => 'فروردین',
            'start' => '01-01',
            'end' => '01-31'
        ];
        $months[2]= [
            'name' => 'اردیبهشت',
            'start' => '02-01',
            'end' => '02-31'
        ];
        $months[3]= [
            'name' => 'خرداد',
            'start' => '03-01',
            'end' => '03-31'
        ];
        $months[4]= [
            'name' => 'تیر',
            'start' => '04-01',
            'end' => '04-31'
        ];
        $months[5]= [
            'name' => 'مرداد',
            'start' => '05-01',
            'end' => '05-31'
        ];
        $months[6]= [
            'name' => 'شهریور',
            'start' => '06-01',
            'end' => '06-31'
        ];
        $months[7]= [
            'name' => 'مهر',
            'start' => '07-01',
            'end' => '07-30'
        ];
        $months[8]= [
            'name' => 'آبان',
            'start' => '08-01',
            'end' => '08-30'
        ];
        $months[9]= [
            'name' => 'آذر',
            'start' => '09-01',
            'end' => '09-30'
        ];
        $months[10]= [
            'name' => 'دی',
            'start' => '10-01',
            'end' => '10-30'
        ];
        $months[11]= [
            'name' => 'بهمن',
            'start' => '11-01',
            'end' => '11-30'
        ];
        $months[12]= [
            'name' => 'اسفند',
            'start' => '12-01',
            'end' => '12-29'
        ];

        $i = 1; //an Counter for month
        foreach ($months as $month){
            $item = [];
            $item['id'] = $i ++;
            $item['month'] = $month['name'];
            $month['start'] = $selectYear.'-'.$month['start'];
            $month['end'] = $selectYear.'-'.$month['end'];
            $item['start'] = Verta::parse($month['start'])->toCarbon()->format('Y-m-d');
            $item['end'] = Verta::parse($month['end'])->toCarbon()->format('Y-m-d');
            $item['total'] = Order::select('price')->whereBetween('created_at', [$item['start'], $item['end']])->get()->sum('price');
            array_push($reports,$item);
        }

        $orders = \App\Models\Order::select('*');
        $customers = \App\Models\Customer::select('*');

        return view('admin.adminPanel',compact('reports','selectYear','orders','customers'));
    }
}
