<?php

namespace App\Http\Controllers;

use App\Models\Server;
use Illuminate\Http\Request;

class ManageServersController extends Controller
{

    public function __construct()
    {
        $this->middleware('can:manage-servers');
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $servers= Server::query()->paginate(10);
        return view('admin.servers.viewServers',compact('servers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.servers.addServer');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'ip' => ['required', 'string', 'max:255'],
        ]);

        Server::create([
            'name' =>  $data['name'],
            'ip' =>  $data['ip'],
        ]);

        return redirect(route('servers.index'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Server $server)
    {
        return view('admin.servers.editServer' , compact('server'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Server $server)
    {
        $data = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'ip' => ['required', 'string', 'max:255'],
        ]);

        $server->update([
            'name' =>  $data['name'],
            'ip' =>  $data['ip'],
        ]);

        return redirect(route('servers.index'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Server $server)
    {
        $server->delete();
        return redirect(route('servers.index'));
    }
}
