@component('admin.adminMaster.content' , ['title' => 'گزارشات مالی'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">گزارشات مالی</li>
    @endslot

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{'گزارشات ماهیانه _ سال مالی '.$selectYear}}</h3>
                    <div class="card-tools d-flex">
                        <form action="{{ route('financial.MonthlyReports') }}"  method="get">
                        <div class="input-group input-group-sm" style="width: 300px;">
                                <label style="margin: 5px;">سال مالی</label>
                                <select name="year" class="form-control">
                                    <option disabled selected>سال مالی را انتخاب کنید</option>
                                    <?php
                                    foreach ($years as $item){
                                        echo '<option value="'.verta($item->created_at)->year.'">'.verta($item->created_at)->year.'</option>';
                                    }?>
                                </select>
                            <div class="input-group-append" style="margin-bottom: 5px">
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>ماه</th>
                            <th>از تاریخ (میلادی)</th>
                            <th>تا تاریخ (میلادی)</th>
                            <th>مجموع درآمد</th>
                            <th>اقدامات</th>
                        </tr>
                        <?php
                        foreach ($reports as $item){
                        ?>
                        <tr>
                            <td>{{$item['id']}}</td>
                            <td>{{$item['month']}}</td>
                            <td>{{$item['start']}}</td>
                            <td>{{$item['end']}}</td>
                            <td>{{number_format($item['total'], 0, '.', ',').' تومان'}}</td>
                            <td class="d-flex">
                                <form action="{{ route('financial.ReportDetails') }}"
                                      method="POST">
                                    <input type="hidden" name="start" value="{{$item['start']}}" />
                                    <input type="hidden" name="end" value="{{$item['end']}}" />
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-info mr-1">جزئیات فروش</button>
                                </form>
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                {{--<div class="card-footer">
                    {{$reports->render()}}
                </div>--}}
            </div>
            <!-- /.card -->
        </div>
    </div>

@endcomponent
