<?php
use Carbon\Carbon;
?>
@component('admin.adminMaster.content' , ['title' => 'جزئیات فروش'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('financial.MonthlyReports') }}">گزارشات مالی</a></li>
        <li class="breadcrumb-item active">جزئیات فروش</li>
    @endslot

    <div class="row">
        <div class="col-12">
            <!-- /.card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">جزئیات فروش _ {{$month}} ماه {{$year}} </h3>
                    <div class="card-tools d-flex">
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>مشتری</th>
                            <th>نام کاربری</th>
                            <th>سرور</th>
                            <th>اپراتور</th>
                            <th>وضعیت</th>
                            <th>قیمت</th>
                            <th>وضعیت پرداخت</th>
                            <th>اخرین ویرایش</th>
                            <th>تاریخ ثبت</th>
                            <th>تاریخ انقضا</th>
                            <th>تاریخ ویرایش</th>
                            <th>اقدامات</th>
                        </tr>
                        <?php
                        foreach ($orders as $item){
                            ?>
                        @if($item->expired_at > Carbon::now())
                            <tr>
                        @else
                            <tr style="color: #ff0000">
                                @endif
                                <td>{{$item->id}}</td>
                                <td>{{$item->whoOrder($item->customer_id)->email}}</td>
                                <td>{{$item->whoOrder($item->customer_id)->username}}</td>
                                <td>{{$item->whatServer($item->server_id)->name}}<br>
                                    {{$item->whatServer($item->server_id)->ip}}</td>
                                <td>{{$item->operator}}</td>
                                <td>
                                    @if($item->expired_at > Carbon::now())
                                        <span class="badge badge-success">فعال</span>
                                    @else
                                        <span class="badge badge-danger">منقضی شده</span>
                                    @endif
                                </td>
                                <td>{{number_format($item->price, 0, '.', ',').' تومان'}}</td>
                                <td>
                                    @if($item->pay_status == 1)
                                        <span class="badge badge-success">تایید</span>
                                    @else
                                        <span class="badge badge-danger">پرداخت نشده</span>
                                    @endif
                                </td>
                                <td>{{$item->whocreate($item->person_id)->name}}</td>
                                <td>{{$item->created_at}}</td>
                                <td>{{$item->expired_at}}</td>
                                <td>{{$item->updated_at}}</td>
                                <td class="d-flex">
                                    <a href="{{ route('orders.edit' , ['order' => $item->id]) }}"
                                       class="btn btn-info btn-sm mr-1">ویرایش</a>
                                    <form action="{{ route('orders.destroy' , ['order' => $item->id]) }}"
                                          method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger mr-1">حذف</button>
                                    </form>
                                </td>
                            </tr>
                            <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    {{$orders->render()}}
                </div>
            </div>
        </div>
    </div>

@endcomponent
