<?php
use Modules\Acl\Entities\Role;
?>
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="/" class="brand-link">
        <img src="/dist/img/AdminLTELogo.png" alt="AdminLTE Logo" class="brand-image img-circle elevation-3"
             style="opacity: .8">
        <span class="brand-text font-weight-light">پنل مدیریت</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar" style="direction: ltr">
        <div style="direction: rtl">
            <!-- Sidebar user panel (optional) -->
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="image">
                    <img src="/dist/img/avatar.png"
                         class="img-circle elevation-2" alt="User Image">
                </div>
                <div class="info">
                    @if(auth()->check())
                        <a href="#" class="d-block"><?= auth()->user()->name ?></a>
                    <?php $rolename = "تعریف نشده"; if(auth()->user()->roles()->get()->first() != null){$rolename = auth()->user()->roles()->get()->first()->label;} ?>
                        <a style="font-size: small;" href="#"><i class="fa fa-circle text-success"></i>{{$rolename}}</a>
                    @else
                        <a href="{{route('login')}}" class="d-block"><b>لطفا وارد شوید</b></a>
                    @endif
                </div>
            </div>

            <!-- Sidebar Menu -->
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    <!-- Add icons to the links using the .nav-icon class
                         with font-awesome or any other icon font library -->
                    <li class="nav-header">منو</li>
                    <li class="nav-item has-treeview">
                        <a href="/admin/panel" class="nav-link {{isActive('admin/panel')}}">
                            <i class="nav-icon fa fa-dashboard"></i>
                            <p>
                                داشبورد
                                <i class="right fa"></i>
                            </p>
                        </a>
                    </li>
                    @can('manage-orders')
                        <li class="nav-item has-treeview {{isActive(['admin/orders','admin/searchOrders','admin/orders/create','admin/orders/{order}/edit'], 'menu-open')}}">
                            <a href="#" class="nav-link {{isActive(['admin/orders','admin/searchOrders','admin/orders/create','admin/orders/{order}/edit'])}}">
                                <i class="nav-icon fa fa-shopping-cart"></i>
                                <p>
                                    مدیریت سفارشات
                                    <i class="right fa fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{route('orders.create')}}" class="nav-link {{isActive('admin/orders/create')}}"><i class="fa fa-plus"></i> <p>سفارش جدید</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{route('orders.index')}}" class="nav-link {{isActive('admin/orders')}}"><i class="fa fa-bars"></i> <p>همه کانفینگ ها</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{'/admin/searchOrders?status=1'}}" class="nav-link {{isActive('admin/searchOrders?status=1')}}"><i class="fa fa-bars"></i> <p>کانفینگ های فعال</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{'/admin/searchOrders?status=0'}}" class="nav-link {{isActive('admin/searchOrders?status=0')}}"><i class="fa fa-bars"></i> <p>کانفینگ های منقضی شده</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{'/admin/searchOrders'}}" class="nav-link {{isActive('admin/searchOrders')}}"><i class="fa fa-search"></i> <p>جست و جو</p></a>
                                </li>
                            </ul>
                        </li>
                    @endcan
                    @can('manage-customers')
                        <li class="nav-item has-treeview {{isActive(['admin/customers'], 'menu-open')}}">
                            <a href="#" class="nav-link {{isActive(['admin/customers'])}}">
                                <i class="nav-icon fa fa-user-circle"></i>
                                <p>
                                    مدیریت مشتریان
                                    <i class="right fa fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{route('customers.index')}}" class="nav-link {{isActive('admin/customers')}}"><i class="fa fa-bars"></i> <p>لیست مشتریان</p></a>
                                </li>
                            </ul>
                        </li>
                    @endcan
                    @can('manage-servers')
                        <li class="nav-item has-treeview {{isActive(['admin/servers','admin/servers/create'], 'menu-open')}}">
                            <a href="#" class="nav-link {{isActive(['admin/servers','admin/servers/create'])}}">
                                <i class="nav-icon fa fa-server"></i>
                                <p>
                                    مدیریت سرورها
                                    <i class="right fa fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{route('servers.index')}}" class="nav-link {{isActive('admin/servers')}}"><i class="fa fa-bars"></i> <p>لیست سرورها</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{route('servers.create')}}" class="nav-link {{isActive('admin/servers/create')}}"><i class="fa fa-plus"></i> <p>افزودن سرور</p></a>
                                </li>
                            </ul>
                        </li>
                    @endcan
                    @can('manage-financial')
                        <li class="nav-item has-treeview {{isActive(['admin/getMonthlyReports'], 'menu-open')}}">
                            <a href="#" class="nav-link {{isActive(['admin/getMonthlyReports'])}}">
                                <i class="nav-icon fa fa-dollar"></i>
                                <p>
                                    مدیریت مالی
                                    <i class="right fa fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{route('financial.MonthlyReports')}}" class="nav-link {{isActive('admin/getMonthlyReports')}}"><i class="fa fa-bars"></i> <p>گزارشات</p></a>
                                </li>
                            </ul>
                        </li>
                    @endcan
                    @can('view-users')
                        <li class="nav-item has-treeview {{isActive(['admin/users','admin/users/create','admin/users/{user}/edit','/admin/editAccess','admin/permissions/givePermission','admin/roles/giveRole'], 'menu-open')}}">
                            <a href="#" class="nav-link {{isActive(['admin/users','admin/users/create','admin/users/{user}/edit','/admin/editAccess','admin/permissions/givePermission','admin/roles/giveRole'])}}">
                                <i class="nav-icon fa fa-users"></i>
                                <p>
                                    مدیریت کارمندان
                                    <i class="right fa fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{route('users.index')}}" class="nav-link {{isActive('admin/users')}}"><i class="fa fa-bars"></i> <p>لیست کارمندان</p></a>
                                </li>
                                @can('create-user')
                                    <li class="nav-item">
                                        <a href="{{route('users.create')}}" class="nav-link {{isActive('admin/users/create')}}"><i class="fa fa-plus"></i> <p>افزودن کارمند جدید</p></a>
                                    </li>
                                @endcan
                                @can('users-role-manage')
                                    <li class="nav-item">
                                        <a href="{{route('roles.give')}}" class="nav-link {{isActive('admin/roles/giveRole')}}"><i class="fa fa-plus"></i> <p>دادن نقش به کارمند</p></a>
                                    </li>
                                @endcan
                                @can('users-permission-manage')
                                    <li class="nav-item">
                                        <a href="{{route('permissions.give')}}" class="nav-link {{isActive('admin/permissions/givePermission')}}"><i class="fa fa-plus"></i> <p>دادن دسترسی خاص به کارمند</p></a>
                                    </li>
                                @endcan
                            </ul>
                        </li>
                    @endcan
                    @can('users-permission-manage')
                        <li class="nav-item has-treeview {{isActive(['admin/permissions','admin/permissions/create','admin/permissions/{permission}/edit','admin/roles','admin/roles/create','admin/roles/{role}/edit','admin/permissions/{permission}','admin/roles/{role}','admin/roles/giveRolePer'], 'menu-open')}}">
                            <a href="#" class="nav-link {{isActive(['admin/permissions','admin/permissions/create','admin/permissions/{permission}/edit','admin/roles','admin/roles/create','admin/roles/{role}/edit','admin/permissions/{permission}','admin/roles/{role}','admin/roles/giveRolePer'])}}">
                                <i class="nav-icon fa fa-universal-access"></i>
                                <p>
                                    مدیریت دسترسی ها
                                    <i class="right fa fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{route('permissions.index')}}" class="nav-link {{isActive('admin/permissions')}}"><i class="fa fa-bars"></i> <p>لیست دسترسی ها</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{route('roles.index')}}" class="nav-link {{isActive('admin/roles')}}"><i class="fa fa-bars"></i> <p>لیست نقش ها</p></a>
                                </li>
                                <li class="nav-item">
                                    <a href="{{route('roleper.give')}}" class="nav-link {{isActive('admin/roles/giveRolePer')}}"><i class="fa fa-bars"></i> <p>مدیریت دسترسی نقش ها</p></a>
                                </li>
                            </ul>
                        </li>
                    @endcan
                    <li class="nav-item">
                        <form action="{{ route('logout') }}" method="post">
                            @csrf
                            <button class="btn btn-danger btn-block">خروج</button>
                        </form>
                    </li>
                </ul>
            </nav>
            <!-- /.sidebar-menu -->
        </div>
    </div>
    <!-- /.sidebar -->
</aside>
