@component('admin.adminMaster.content' , ['title' => 'مقالات'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">مشاهده مقالات</li>
    @endslot

    <section class="content">
        <!-- /.row -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">همه مقالات</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                                @can('add-new-article')
                                    <div class="btn-group-sm mr-1">
                                        <a href="/admin/newArticle" class="btn btn-info">افزودن مقاله جدید
                                            <li class="fa fa-pencil"></li>
                                        </a>
                                    </div>
                                @endcan
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>ردیف</th>
                                <th>عنوان</th>
                                <th>دسته بندی</th>
                                <th>نویسنده</th>
                                <th>وضعیت</th>
                                <th>تاریخ انتشار</th>
                                <th>عملیات</th>
                            </tr>
                            <?php
                            $counter = 1;
                            foreach ($article as $item){
                            ?>
                            <tr>
                                <td>{{$counter ++}}</td>
                                <td>{{$item->title}}</td>
                                <td>{{$item->category}}</td>
                                <td>{{$item->wrname}}</td>
                                <td>
                                    @if($item->status)
                                        <span class="badge badge-success">منتشر شده</span>
                                    @else
                                        <span class="badge badge-danger">غیر فعال</span>
                                    @endif
                                </td>
                                <td><?=verta($item->created_at)->format('Y.m.d')."<br>".verta($item->created_at)->format('H:i:s')?></td>
                                <td>
                                    @can('edit-articles')
                                        <a href="/admin/editArticle/{{$item->id}}"
                                           class="btn btn-info btn-sm">ویرایش</a>
                                    @endcan
                                    @can('manage-articles')
                                        <a href="/admin/changeArticleStatus/{{$item->id}}"
                                           class="btn btn-warning btn-sm">تغییر وضعیت</a>
                                        <a href="/admin/deleteArticle/{{$item->id}}"
                                           class="btn btn-danger btn-sm">حذف</a>
                                    @endcan
                                </td>
                            </tr>
                            <?php } ?>

                        </table>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        {{$article->render()}}
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </section>

@endcomponent
