@component('admin.adminMaster.content' , ['title' => 'ویرایش دسته بندی ها'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="/admin/viewCategories">دسته بندی ها</a></li>
        <li class="breadcrumb-item active">ویرایش دسته بندی</li>
    @endslot

    <div class="card card-info card-outline">
        <div class="card-header">
            <h3 class="card-title">ویرایش دسته بندی ها
            </h3>
        </div>
        @if($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{$error}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <!-- /.card-header -->
        <div class="card-body">
            <form action="/admin/editCategory/{{$category->id}}" method="post" enctype="multipart/form-data">
                @csrf
                <table class="table table-bordered">
                    <tr>
                        <td style="width: 50%">
                            <div class="form-group">
                                <label for="name">نام دسته بندی</label>
                                <input type="text" name="name" class="form-control" id="name"
                                       placeholder="نام دسته بندی" value="{{$category->name}}" required="required">
                            </div>
                        </td>
                        <td style="width: 50%">
                            <div class="form-group">
                                <label for="slug">آدرس یکتا</label>
                                <input type="text" name="slug" class="form-control" id="slug"
                                       value="{{$category->slug}}" placeholder="آدرس یکتا" required="required">
                            </div>
                        </td>
                    </tr>
                </table>
                <button style="width: fit-content;" class="btn btn-block btn-danger btn-lg" type="submit">ویرایش
                </button>
            </form>
        </div>
    </div>
@endcomponent
