@component('admin.adminMaster.content' , ['title' => 'دسته بندی جدید'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="/admin/viewCategories">دسته بندی ها</a></li>
        <li class="breadcrumb-item active">دسته بندی جدید</li>
    @endslot

    <div class="card card-info card-outline">
        <div class="card-header">
            <h3 class="card-title">افزودن دسته بندی جدید
            </h3>
        </div>
        @if($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{$error}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <!-- /.card-header -->
        <div class="card-body">
            <form action="/admin/newCategory" method="post" enctype="multipart/form-data">
                @csrf
                <table class="table table-bordered">
                    <tr>
                        <td style="width: 50%">
                            <div class="form-group">
                                <label for="name">نام دسته بندی</label>
                                <input type="text" name="name" class="form-control" id="name" placeholder="نام دسته بندی" required="required">
                            </div>
                        </td>
                        <td style="width: 50%">
                            <div class="form-group">
                                <label for="slug">آدرس یکتا</label>
                                <input type="text" name="slug" class="form-control" id="slug" placeholder="آدرس یکتا" required="required">
                            </div>
                        </td>
                    </tr>
                </table>
                <button class="btn btn-block btn-primary btn-lg"  type="submit">افزودن</button>
            </form>
        </div>
    </div>

@endcomponent

