@component('admin.adminMaster.content' , ['title' => 'دسته بندی ها'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">دسته بندی ها</li>
    @endslot

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">مشاهده دسته بندی ها</h3>
                        <div class="card-tools d-flex">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="table_search" class="form-control float-right"
                                       placeholder="جستجو">

                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                </div>
                                @can('manage-categories')
                                    <div class="btn-group-sm mr-1">
                                        <a href="/admin/newCategory/" class="btn btn-info">افزودن دسته جدید
                                            <li class="fa fa-pencil"></li>
                                        </a>
                                    </div>
                                @endcan
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">
                            <tr>
                                <th>عنوان</th>
                                <th>آدرس کوتاه</th>
                                <th>تاریخ ایجاد</th>
                                <th>عملیات</th>
                            </tr>
                            <?php
                            foreach ($category as $item){
                            ?>
                            <tr>
                                <td>{{$item->name}}</td>
                                <td>{{$item->slug}}</td>
                                <td>{{$item->created_at}}</td>
                                @can('manage-categories')
                                    <td><a href="/admin/editCategory/<?=$item->id ?>"
                                           class="btn btn-info btn-sm">ویرایش</a>
                                        <a href="/admin/deleteCategory/<?=$item->id ?>"
                                           class="btn btn-danger btn-sm">حذف</a></td>
                                @endcan
                            </tr>
                            <?php } ?>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        {{$category->render()}}
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    </section>

@endcomponent
