@component('admin.adminMaster.content' , ['title' => 'مشاهده دیدگاه'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="/admin/viewComments">نظرات</a></li>
        <li class="breadcrumb-item active">مشاهده دیدگاه</li>
    @endslot

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">مشاهده دیدگاه</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-responsive p-0">
                        <table class="table table-hover">

                            <tr>
                                <th colspan="2">نام نویسنده</th>
                                <th colspan="2">متن نظر</th>
                            </tr>
                            <tr>
                                <td colspan="2">{{$comment->writer}}</td>
                                <td colspan="2">{{$comment->body}}</td>
                            </tr>
                            <tr>
                                <th>وضعیت</th>
                                <th>تاریخ ثبت</th>
                                <th>ایمیل نویسنده</th>
                                <th>نام مقاله</th>

                            </tr>
                            <tr>
                                <td>
                                    @if($comment->status == 0)
                                        <span class="badge badge-danger">رد شده</span>
                                    @elseif($comment->status == 1)
                                        <span class="badge badge-success">تایید شده</span>
                                    @else
                                        <span class="badge badge-warning">در انتظار بررسی</span>
                                    @endif
                                </td>
                                <td>{{$comment->created_at}}</td>
                                <td>{{$comment->email}}</td>
                                <td>{{$comment->title}}</td>
                            </tr>
                            @can('manage-comments')
                                <tr>
                                    <td colspan="5">
                                        <a href="/admin/acceptComment/{{$comment->id}}"
                                           class="btn btn-success btn-sm <?php if ($comment->status == 1) {echo "disabled";} ?>">تایید</a>
                                        <a href="/admin/rejecComment/{{$comment->id}}"
                                           class="btn bg-danger btn-sm <?php if ($comment->status == 0) {echo "disabled";} ?>">رد</a>
                                        <a href="/admin/editComment/{{$comment->id}}" class="btn btn-primary btn-sm">ویرایش</a>
                                        <a href="/admin/deleteComment/{{$comment->id}}"
                                           class="btn bg-danger-gradient btn-sm">حذف</a>
                                    </td>
                                </tr>
                            @endcan
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>

@endcomponent
