@component('admin.adminMaster.content' , ['title' => 'ویرایش سفارش'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('orders.index') }}">لیست کافینگ ها</a></li>
        <li class="breadcrumb-item active">ویرایش سفارش</li>
    @endslot
        <div class="row">
            <div class="col-12">
                @include('admin.adminMaster.errors')
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">ویرایش سفارش</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form class="form-horizontal" action="{{route('orders.update' , ['order' => $order->id])}}" method="post">
                        @csrf
                        @method('PATCH')

                        <div class="card-body">
                            <div class="form-group">
                                <label for="inputEmail3" class="col-sm-2 control-label">ایمیل مشتری</label>
                                <input type="email" name="email" class="form-control" id="inputEmail3" readonly="readonly" value="{{ $order->whoOrder($order->customer_id)->email }}">
                            </div>
                            <div class="form-group">
                                <label>سرور</label>
                                <select name="server" class="form-control">
                                    <option value="{{$order->whatServer($order->server_id)->id}}" selected>{{$order->whatServer($order->server_id)->name}}</option>
                                    <?php
                                    $servers = \App\Models\Server::select('id','name')->get();
                                    foreach ($servers as $item){
                                        echo '<option value="'.$item->id.'">'.$item->name.'</option>';
                                    }?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>اپراتور</label>
                                <select name="operator" class="form-control">
                                    <option selected>{{$order->operator}}</option>
                                    <option>ایرانسل</option>
                                    <option>همراه اول</option>
                                    <option>رایتل</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>تاریخ شروع</label>
                                <div class="input-group">
                                    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-calendar"></i></span></div>
                                    <input type="text" id="startdatepicker" name="start_date" class="form-control ltr" value="{{ $order->created_at }}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>تاریخ پایان</label>
                                <div class="input-group">
                                    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-calendar"></i></span></div>
                                    <input type="text" id="enddatepicker" name="end_date" class="form-control ltr" value="{{ $order->expired_at }}">
                                </div>
                            </div>
                            <div class="form-check">
                                <label for="Price" class="col-sm-2 control-label">قیمت</label>
                                <input type="number" inputmode="numeric" data-type="currency" name="Price" class="form-control" id="Price" placeholder="قیمت را وارد کنید" value="{{$order->price}}" >
                                @if($order->pay_status == 1)
                                    <input type="checkbox" name="pay_status" class="form-check-input" id="verify" checked>
                                @else
                                    <input type="checkbox" name="pay_status" class="form-check-input" id="verify">
                                @endif
                                <label class="form-check-label" for="pay_status">پرداخت شده</label>
                            </div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
                            <button type="submit" class="btn btn-info">ویرایش سفارش</button>
                            <a href="{{route('orders.index')}}" class="btn btn-default float-left">لغو</a>
                        </div>
                        <!-- /.card-footer -->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
        <!-- /.row -->
    @slot('script')
        <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
        <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
        <script>
            $( function() {
                $( "#startdatepicker" ).datepicker({
                    changeMonth: true,
                    changeYear: true
                });
                $( "#enddatepicker" ).datepicker({
                    changeMonth: true,
                    changeYear: true
                });
                $(document).ready(function() {
                    $( "#startdatepicker" ).datepicker( "option", "dateFormat", "yy-mm-dd" );
                    $( "#enddatepicker" ).datepicker( "option", "dateFormat", "yy-mm-dd" );
                });
            } );
        </script>
    @endslot
@endcomponent
