<?php
use Carbon\Carbon;
?>
@component('admin.adminMaster.content' , ['title' => 'جست و جو'])
    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item"><a href="{{ route('orders.index') }}">لیست کافینگ ها</a></li>
        <li class="breadcrumb-item active">جست و جو</li>
    @endslot

    <div class="row">
        <div class="col-12">
            <div class="card card-info card-outline">
                <div class="card-header">
                    <h3 class="card-title">فیلتر ها
                    </h3>
                </div>
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach($errors->all() as $error)
                                <li>{{$error}}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <!-- /.card-header -->
                <div class="card-body">
                    <form action="{{route('orders.Exsearch')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <table class="table table-bordered">
                            <tr>
                                <td style="width: 50%">
                                    <div class="form-group">
                                        <label for="email" class="col-sm-2 control-label">ایمیل مشتری</label>
                                        <input type="email" name="email" class="form-control" id="inputEmail3" placeholder="ایمیل را وارد کنید">
                                    </div>
                                </td>
                                <td style="width: 50%">
                                    <div class="form-group">
                                        <label for="username" class="col-sm-5 control-label">نام کاربری (username)</label>
                                        <input type="text" name="username" class="form-control" id="username" placeholder="نام کاربری را وارد کنید">
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 50%">
                                    <div class="form-group">
                                        <label>سرور</label>
                                        <select name="server" class="form-control">
                                            <option>انتخاب نشده</option>
                                            <?php
                                            $servers = \App\Models\Server::select('name')->groupBy('name')->get();
                                            foreach ($servers as $item){
                                                echo '<option value="'.$item->id.'">'.$item->name.'</option>';
                                            }?>
                                        </select>
                                    </div>
                                </td>
                                <td style="width: 50%">
                                    <div class="form-group">
                                        <label>اپراتور</label>
                                        <select name="operator" class="form-control">
                                            <option>انتخاب نشده</option>
                                            <?php
                                            $configs = \App\Models\Order::select('operator')->groupBy('operator')->get();
                                            foreach ($configs as $item){
                                                echo "<option>".$item->operator."</option>";
                                            }?>
                                        </select>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 50%">
                                    <div class="form-group">
                                        <label>وضعیت</label>
                                        <select name="status" class="form-control">
                                            <option>انتخاب نشده</option>
                                            <option value="1">فعال</option>
                                            <option value="0">منقضی شده</option>
                                        </select>
                                    </div>
                                </td>
                                <td style="width: 50%">
                                    <div class="form-group">
                                        <label>وضعیت پرداخت</label>
                                        <select name="pay_status" class="form-control">
                                            <option>انتخاب نشده</option>
                                            <option value="1">تایید</option>
                                            <option value="0">پرداخت نشده</option>
                                        </select>
                                    </div>
                                </td>
                            </tr>
                        </table>
                        <button style="width: 10%" class="btn btn-block btn-primary"  type="submit"><i class="fa fa-search ml-1"></i>جست و جو</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست کانفینگ ها</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>مشتری</th>
                            <th>نام کاربری</th>
                            <th>سرور</th>
                            <th>اپراتور</th>
                            <th>وضعیت</th>
                            <th>قیمت</th>
                            <th>وضعیت پرداخت</th>
                            <th>اخرین ویرایش</th>
                            <th>تاریخ ثبت</th>
                            <th>تاریخ انقضا</th>
                            <th>تاریخ ویرایش</th>
                            <th>اقدامات</th>
                        </tr>
                        <?php
                        foreach ($orders as $item){
                            ?>
                        @if($item->expired_at > Carbon::now())
                            <tr>
                        @else
                            <tr style="color: #ff0000">
                                @endif
                                <td>{{$item->id}}</td>
                                <td>{{$item->whoOrder($item->customer_id)->email}}</td>
                                <td>{{$item->whoOrder($item->customer_id)->username}}</td>
                                <td>{{$item->whatServer($item->server_id)->name}}<br>
                                    {{$item->whatServer($item->server_id)->ip}}</td>
                                <td>{{$item->operator}}</td>
                                <td>
                                    @if($item->expired_at > Carbon::now())
                                        <span class="badge badge-success">فعال</span>
                                    @else
                                        <span class="badge badge-danger">منقضی شده</span>
                                    @endif
                                </td>
                                <td>{{number_format($item->price, 0, '.', ',').' تومان'}}</td>
                                <td>
                                    @if($item->pay_status == 1)
                                        <span class="badge badge-success">تایید</span>
                                    @else
                                        <span class="badge badge-danger">پرداخت نشده</span>
                                    @endif
                                </td>
                                <td>{{$item->whocreate($item->person_id)->name}}</td>
                                <td>{{$item->created_at}}</td>
                                <td>{{$item->expired_at}}</td>
                                <td>{{$item->updated_at}}</td>
                                <td class="d-flex">
                                    <a href="{{ route('orders.edit' , ['order' => $item->id]) }}"
                                       class="btn btn-info btn-sm mr-1">ویرایش</a>
                                    <form action="{{ route('orders.destroy' , ['order' => $item->id]) }}"
                                          method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger mr-1">حذف</button>
                                    </form>
                                </td>
                            </tr>
                            <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    {{$orders->render()}}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>

@endcomponent
