<?php $__env->startComponent('admin.adminMaster.content' , ['title' => 'کاربران']); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">لیست کاربران</li>
    <?php $__env->endSlot(); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست کاربران</h3>
                    <div class="card-tools d-flex">
                        <div class="input-group input-group-sm" style="width: 300px;">
                            <input type="text" name="table_search" class="form-control float-right" placeholder="جستجو">

                            <div class="input-group-append">
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create-user')): ?>
                                <div class="btn-group-sm mr-1">
                                    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-info">افزودن کاربر جدید
                                        <li class="fa fa-pencil"></li>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>نام</th>
                            <th>ایمیل</th>
                            <th>وضعیت ایمیل</th>
                            <th>نقش کاربر</th>
                            <th>تاریخ ثبت نام</th>
                        </tr>
                        <?php
                        foreach ($users as $item){
                        ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->name); ?></td>
                            <td><?php echo e($item->email); ?></td>
                            <td>
                                <?php if($item->email_verified_at !== null): ?>
                                    <span class="badge badge-success">تایید شده</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">تایید نشده</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($item->roles()->get()->first() == null): ?>
                                    <?= "تعریف نشده" ?>
                                <?php endif; ?>
                                <?php $__currentLoopData = $item->roles()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?= "*" ?>
                                    <?php echo e($role->label); ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td><?php echo e($item->created_at); ?></td>
                            <td class="d-flex">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-user')): ?>
                                    <a href="<?php echo e(route('users.edit' , ['user' => $item->id])); ?>"
                                       class="btn btn-info btn-sm">ویرایش</a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-user')): ?>
                                    <form action="<?php echo e(route('users.destroy' , ['user' => $item->id])); ?>"
                                          method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger mr-1">حذف</button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <?php echo e($users->render()); ?>

                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>

<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/birvpn/public_html/resources/views/admin/users/viewUsers.blade.php ENDPATH**/ ?>