<?php $__env->startComponent('admin.adminMaster.content' , ['title' => 'مشتریان']); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">لیست مشتریان</li>
    <?php $__env->endSlot(); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست مشتریان</h3>
                    <div class="card-tools d-flex">
                        <div class="input-group input-group-sm" style="width: 300px;">
                            <input type="text" name="table_search" class="form-control float-right" placeholder="جستجو">

                            <div class="input-group-append">
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>ایمیل</th>
                            <th>نام کاربری (username)</th>
                            <th>ایجاد کننده</th>
                            <th>تاریخ ثبت نام</th>
                            <th>اقدامات</th>
                        </tr>
                        <?php
                        foreach ($customers as $item){
                        ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->email); ?></td>
                            <td><?php echo e($item->username); ?></td>
                            <td><?php echo e($item->whocreate($item->person_id)->name); ?></td>
                            <td><?php echo e($item->created_at); ?></td>
                            <td class="d-flex">
                                    <a href="<?php echo e(route('customers.show' , ['customer' => $item->id])); ?>"
                                       class="btn btn-warning btn-sm">مشاهده سوابق</a>
                                    <a href="<?php echo e(route('customers.edit' , ['customer' => $item->id])); ?>"
                                       class="btn btn-info btn-sm mr-1">ویرایش</a>
                                    <form action="<?php echo e(route('customers.destroy' , ['customer' => $item->id])); ?>"
                                          method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger mr-1">حذف</button>
                                    </form>
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <?php echo e($customers->render()); ?>

                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>

<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/birvpn/public_html/resources/views/admin/customers/viewCustomers.blade.php ENDPATH**/ ?>