<?php
use Carbon\Carbon;
?>
<?php $__env->startComponent('admin.adminMaster.content' , ['title' => 'سفارشات']); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">لیست کانفینگ ها</li>
    <?php $__env->endSlot(); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست کانفینگ ها</h3>
                    <div class="card-tools d-flex">
                        <div class="input-group input-group-sm" style="width: 300px;">
                            <input type="text" name="table_search" class="form-control float-right" placeholder="جستجو">

                            <div class="input-group-append">
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>مشتری</th>
                            <th>نام کاربری</th>
                            <th>سرور</th>
                            <th>اپراتور</th>
                            <th>وضعیت</th>
                            <th>قیمت</th>
                            <th>وضعیت پرداخت</th>
                            <th>اخرین ویرایش</th>
                            <th>تاریخ ثبت</th>
                            <th>تاریخ انقضا</th>
                            <th>تاریخ ویرایش</th>
                            <th>اقدامات</th>
                        </tr>
                        <?php
                        foreach ($orders as $item){
                        ?>
                        <?php if($item->expired_at > Carbon::now()): ?>
                            <tr>
                        <?php else: ?>
                            <tr style="color: #ff0000">
                        <?php endif; ?>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->whoOrder($item->customer_id)->email); ?></td>
                            <td><?php echo e($item->whoOrder($item->customer_id)->username); ?></td>
                            <td><?php echo e($item->whatServer($item->server_id)->name); ?><br>
                                <?php echo e($item->whatServer($item->server_id)->ip); ?></td>
                            <td><?php echo e($item->operator); ?></td>
                            <td>
                                <?php if($item->expired_at > Carbon::now()): ?>
                                    <span class="badge badge-success">فعال</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">منقضی شده</span>
                                <?php endif; ?>
                            </td>
                                <td><?php echo e(number_format($item->price, 0, '.', ',').' تومان'); ?></td>
                            <td>
                                <?php if($item->pay_status == 1): ?>
                                    <span class="badge badge-success">تایید</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">پرداخت نشده</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($item->whocreate($item->person_id)->name); ?></td>
                            <td><?php echo e($item->created_at); ?></td>
                            <td><?php echo e($item->expired_at); ?></td>
                            <td><?php echo e($item->updated_at); ?></td>
                            <td class="d-flex">
                                    <a href="<?php echo e(route('orders.edit' , ['order' => $item->id])); ?>"
                                       class="btn btn-info btn-sm mr-1">ویرایش</a>
                                    <form action="<?php echo e(route('orders.destroy' , ['order' => $item->id])); ?>"
                                          method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger mr-1">حذف</button>
                                    </form>
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <?php echo e($orders->render()); ?>

                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>

<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/birvpn/public_html/resources/views/admin/orders/viewOrders.blade.php ENDPATH**/ ?>