<?php $__env->startComponent('admin.adminMaster.content' , ['title' => 'گزارشات مالی']); ?>
    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item"><a href="/admin/panel">پنل مدیریت</a></li>
        <li class="breadcrumb-item active">گزارشات مالی</li>
    <?php $__env->endSlot(); ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e('گزارشات ماهیانه _ سال مالی '.$selectYear); ?></h3>
                    <div class="card-tools d-flex">
                        <form action="<?php echo e(route('financial.MonthlyReports')); ?>"  method="get">
                        <div class="input-group input-group-sm" style="width: 300px;">
                                <label style="margin: 5px;">سال مالی</label>
                                <select name="year" class="form-control">
                                    <option disabled selected>سال مالی را انتخاب کنید</option>
                                    <?php
                                    foreach ($years as $item){
                                        echo '<option value="'.verta($item->created_at)->year.'">'.verta($item->created_at)->year.'</option>';
                                    }?>
                                </select>
                            <div class="input-group-append" style="margin-bottom: 5px">
                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover">
                        <tr>
                            <th>آیدی</th>
                            <th>ماه</th>
                            <th>از تاریخ (میلادی)</th>
                            <th>تا تاریخ (میلادی)</th>
                            <th>مجموع درآمد</th>
                            <th>اقدامات</th>
                        </tr>
                        <?php
                        foreach ($reports as $item){
                        ?>
                        <tr>
                            <td><?php echo e($item['id']); ?></td>
                            <td><?php echo e($item['month']); ?></td>
                            <td><?php echo e($item['start']); ?></td>
                            <td><?php echo e($item['end']); ?></td>
                            <td><?php echo e(number_format($item['total'], 0, '.', ',').' تومان'); ?></td>
                            <td class="d-flex">
                                <form action="<?php echo e(route('financial.ReportDetails')); ?>"
                                      method="POST">
                                    <input type="hidden" name="start" value="<?php echo e($item['start']); ?>" />
                                    <input type="hidden" name="end" value="<?php echo e($item['end']); ?>" />
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-info mr-1">جزئیات فروش</button>
                                </form>
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- /.card-body -->
                
            </div>
            <!-- /.card -->
        </div>
    </div>

<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/birvpn/public_html/resources/views/admin/accounting/reports.blade.php ENDPATH**/ ?>